module Misc.ParametricIR where

open import Prelude.Basic
open import Data.Unit
open import Data.Empty
open import Data.Bool hiding (T)
open import Data.Nat
open import Data.Sum
open import Data.Product
open import Function
open import Relation.Binary.PropositionalEquality
open import Prelude.Equality

-- reflexive graphs

record RG : Set₁ where
  constructor RG[_,_,_,_,_,_,_]
  field
    o : Set
    r : Set
    ref : o → r
    src : r → o
    tgt : r → o
    ul : (x : o) → src ( ref x) ≡ x
    ur : (x : o) → tgt ( ref x) ≡ x
open RG public

-- (notice the difference between 𝒻 (Mcf) and 𝓯 (MCf))
record HomRG (Γ Δ : RG) : Set₁ where
  constructor RG→[_,_,_,_,_,]--_,_]
  field
    𝒻0 : (o Γ) → (o Δ)
    𝒻1 : r Γ → r Δ
    𝒻ref : (x : o Γ) → 𝒻1 (ref Γ x) ≡ ref Δ (𝒻0 x)
    𝒻src : (y : r Γ) → src Δ ( 𝒻1 y) ≡ 𝒻0 (src Γ y)  
    𝒻tgt : (y : r Γ) → tgt Δ ( 𝒻1 y) ≡ 𝒻0 (tgt Γ y)
--    𝒻ul : (x : o Γ) → ul Γ x ≡ ul Δ (𝒻0 x)
--    𝒻ur : (x : o Γ) → ur Γ x ≡ ur Δ (𝒻0 x)
open HomRG public

-- we can derive the action of 𝒻 on the ul and ur fields
-- more precisely it should probably be part of the definition HomRG
-- that ul Γ x be sent to ul Δ 𝒻f x under this function

𝒻ul : {Γ Δ : RG} → {x : o Γ} → (f : HomRG Γ Δ) → (src Γ (ref Γ x) ≡ x) → (src Δ (ref Δ ((𝒻0 f) x)) ≡ ((𝒻0 f) x))
𝒻ul {Γ = Γ} {Δ = Δ} {x = x} f = (λ p → trans (trans (cong (src Δ) (sym ((𝒻ref f) x))) ((𝒻src f) (ref Γ x))) p) ∘ ( λ w → cong (𝒻0 f) w)

𝒻ur : {Γ Δ : RG} → {x : o Γ} → (f : HomRG Γ Δ) → (tgt Γ (ref Γ x) ≡ x) → (tgt Δ (ref Δ ((𝒻0 f) x)) ≡ ((𝒻0 f) x))
𝒻ur {Γ = Γ} {Δ = Δ} {x = x} f = (λ p → trans (trans (cong (tgt Δ) (sym ((𝒻ref f) x))) ((𝒻tgt f) (ref Γ x))) p) ∘ ( λ w → cong (𝒻0 f) w)

-- families of reflexive graphs

record FamRG (Γ : RG) : Set₁ where
  constructor FamRG[_,_,_,_,_,_,_]
  field
    𝒪 : o Γ → Set
    𝓡 : r Γ → Set
    bref : (x : o Γ) → (𝒪 x → 𝓡 (ref Γ x))
    bsrc : (y : r Γ) → (𝓡 y → 𝒪  (src Γ y))
    btgt : (y : r Γ) → (𝓡 y → 𝒪  (tgt Γ y))
    ptul : (x : o Γ) → (bsrc (ref Γ x) ∘ (bref x) ≡ subst 𝒪 (sym (ul Γ x)))
    ptur : (x : o Γ) → (btgt (ref Γ x) ∘ (bref x) ≡ subst 𝒪 (sym ( ur Γ x)))
open FamRG

{- intended "...≡ id", but x != src Γ (ref Γ x) of type o Γ
when checking that the expression id has type
(x₁ : 𝒪 x) → 𝒪 (src Γ (ref Γ x))
-}


record FamRG⇒ (Γ : RG) (A B : FamRG Γ) : Set₁ where
  constructor FamRG⇒[_,_,_,_,_]
  field
    m𝒪 : (x : o Γ) → (𝒪 A x → 𝒪 B x)
    m𝓡 : (y : r Γ) → (𝓡 A y →   𝓡 B y)
    mref : (x : o Γ) → (m𝓡 (ref Γ x)) ∘ (bref A x) ≡ (bref B x) ∘ (m𝒪 x)
    msrc : (y : r Γ) → (m𝒪 (src Γ y)) ∘ (bsrc A y) ≡ (bsrc B y) ∘ (m𝓡 y)
    mtgt : (y : r Γ) → (m𝒪 (tgt Γ y)) ∘ (btgt A y) ≡ (btgt B y) ∘ (m𝓡 y)
open FamRG⇒

paste : {A0 A1 B0 B1 C0 C1 : Set} →
        {fA : A0 → A1} → {fB : B0 → B1} → {fC : C0 → C1} →
        {d01 : A0 → B0} → {d02 : B0 → C0} → {d11 : A1 → B1} → {d12 : B1 → C1} →
        (p1 : d11 ∘ fA ≡ fB ∘ d01) → (p2 : d12 ∘ fB ≡ fC ∘ d02) →
        d12 ∘ d11 ∘ fA ≡ fC ∘ d02 ∘ d01
paste {d01 = d01} {d12 = d12} p1 p2 = trans (cong (λ z → d12 ∘ z) p1)
                                                (cong (λ z → z ∘ d01) p2)

flatpaste : {A B B' C : Set} → {f : A → B} → {f' : B → C} →
            {g : A → B} → {g' : B → C} →
            (q1 : f ≡ g) → (q2 : f' ≡ g') →
            f' ∘ f ≡ g' ∘ g
flatpaste {f' = f'} {g = g'} q1 q2 = trans (cong (λ z → f' ∘ z) q1) (cong (λ z → z ∘ g') q2)

ap : ∀{l}{ X Y : Set l} → {x x' : X} → (f : X → Y) → x ≡ x' → (f x) ≡ (f x')
ap f refl = refl

∘FamRG⇒ : {Γ : RG}{A B C : FamRG Γ} → FamRG⇒ Γ B C → FamRG⇒ Γ A B → FamRG⇒ Γ A C
∘FamRG⇒ {Γ = Γ} {A} {B} {C} g f
  = FamRG⇒[ (λ x → (((m𝒪 g) x) ∘ ((m𝒪 f) x))) ,
            ( λ y → ((m𝓡 g y) ∘ (m𝓡 f y))) ,
            (λ x → paste {fA = bref A x} {bref B x} {bref C x}
                         {m𝒪 f x} {m𝒪 g x}
                         {m𝓡 f (ref Γ x)} {m𝓡 g (ref Γ x)}
                         (mref f x) (mref g x)) ,
            (λ y → paste {fA = bsrc A y} {bsrc B y} {bsrc C y}
                         {m𝓡 f y} {m𝓡 g y}
                         {m𝒪 f (src Γ y)} {m𝒪 g (src Γ y)}
                         (msrc f y) (msrc g y)) ,
            (λ y → paste {fA = btgt A y} {btgt B y} {btgt C y}
                         {m𝓡 f y} {m𝓡 g y}
                         {m𝒪 f (tgt Γ y)} {m𝒪 g (tgt Γ y)}
                         (mtgt f y) (mtgt g y))]


-- homogenous family of reflexive graphs

record homgFamRG (Γ : RG) : Set₁ where
  constructor homgFamRG[_,_,_,_,_,_,_]
  field
    𝒪h : o Γ → Set
    𝓡h : r Γ → Set
    brefh : (x : o Γ) → (𝒪h x → 𝓡h (ref Γ x))
    bsrch : (y : r Γ) → (𝓡h y → 𝒪h  (src Γ y))
    btgth : (y : r Γ) → (𝓡h y → 𝒪h  (tgt Γ y))
    homgh : (y : r Γ) → (𝓡h y → (𝒪h  (src Γ y) ≡ 𝒪h (tgt Γ y)))
    hreflh : (y : r Γ) → (𝓡h y → (𝒪h  (src Γ y) ≡ 𝒪h (tgt Γ y))) → (𝒪h  (src Γ y) →  𝓡h (y))

-- The CwF of reflexive graph-families

-- The unit reflexive graph family over Γ, types, terms

⊤_ : {Γ : RG} -> FamRG Γ
⊤_ = FamRG[ (λ _ → ⊤) , (λ _ → ⊤) , (λ _ → id) , (λ _ → id) , (λ _ → id) , (λ _ → refl) , (λ _ → refl) ]



--⊤⇒ : (Γ Δ : RG) → FamRG⇒ (⊤_ {Γ = Γ}) (⊤_ {Γ = Δ })
--⊤⇒ Γ Δ = FamRG⇒[ (λ x → (λ y → y)) ,  (λ x → (λ y → y)) ,  (λ x → refl) ,  (λ x → refl) ,  (λ x → refl) ]

Ty : (Γ : RG) → Set₁
Ty Γ = FamRG Γ

Tm :  (Γ : RG) → (A : Ty Γ) → Set₁
Tm Γ A = FamRG⇒ Γ ⊤_ A


ID : (Γ : RG) → Ty Γ
ID Γ = FamRG[ (λ x → o Γ) ,  (λ x → r Γ) ,  (λ x → ref Γ) ,  (λ x → src Γ) ,  (λ x → tgt Γ) ,  (λ x → ext (λ y → trans (ul Γ y) (sym (subst-const {B = o Γ} (sym (ul Γ x)))))) , {!!} ]

-- substitution of types, and -of terms

-- here 𝒪 (A [ f ]Ty) x etc is replaced by its definition

subst3 : {Γ Δ : RG} → {A : FamRG Δ} → {x : o Γ} → {f : HomRG Γ Δ} → (𝒪 A (src Δ (ref Δ ((𝒻0 f) x)))) ≡ (𝒪 A  ((𝒻0 f) (src Γ (ref Γ x))))
subst3 {Γ = Γ}{Δ = Δ}{A = A}{x = x}{f = f} = sym (trans (cong (𝒪 A) (sym ((𝒻src f) (ref Γ x)))) (cong (𝒪 A) (cong (src Δ) (((𝒻ref f) x) ))))

subst3r : {Γ Δ : RG} → {A : FamRG Δ} → {x : o Γ} → {f : HomRG Γ Δ} → (𝒪 A (tgt Δ (ref Δ ((𝒻0 f) x)))) ≡ (𝒪 A  ((𝒻0 f) (tgt Γ (ref Γ x))))
subst3r {Γ = Γ}{Δ = Δ}{A = A}{x = x}{f = f} = sym (trans (cong (𝒪 A) (sym ((𝒻tgt f) (ref Γ x)))) (cong (𝒪 A) (cong (tgt Δ) (((𝒻ref f) x) ))))

subst-cd : ∀{l}{A B B' : Set l} → B ≡ B' → (A → B) → (A → B')
subst-cd {A = A} q α = subst (λ X → (A → X)) q α


substTy : {Γ Δ : RG} → Ty Δ → (HomRG Γ Δ ) → Ty Γ
substTy {Γ = Γ} {Δ = Δ} A f = FamRG[ (𝒪 A) ∘ (𝒻0 f) ,
  (𝓡 A) ∘ (𝒻1 f) ,
  (λ x → ((subst (𝓡 A) (sym ((𝒻ref f) x))) ∘ ((bref A) ((𝒻0 f) x)))) ,
  (λ y → (subst (𝒪 A) (((𝒻src f) y))) ∘ ((bsrc A)((𝒻1 f) y))) ,
  (λ y → (subst (𝒪 A) ((𝒻tgt f) y)) ∘ (btgt A)((𝒻1 f) y)) ,
  (λ x →  {!ap {lzero} {(𝒪 A ((𝒻0 f) x)) → (𝒪 A (src Δ (ref Δ ((𝒻0 f)x))))}{(𝒪 A ((𝒻0 f) x)) → (𝒪 A ((𝒻0 f) (src Γ (ref Γ x))))} {(bsrc A (ref Δ ((𝒻0 f) x))) ∘ (bref A ((𝒻0 f)x))}{subst (𝒪 A) (sym (ul Δ ((𝒻0 f) x )))}
  (subst-cd {lzero} {𝒪 A ((𝒻0 f) x)} {𝒪 A (src Δ (ref Δ ((𝒻0 f) x)))} {𝒪 A ((𝒻0 f) (src Γ (ref Γ x)))} (subst3 {Γ = Γ}{Δ = Δ}{A = A}{x = x}{f = f}) ) (ptul A ((𝒻0 f) x))!}) ,
  {!λ x →  ap {lzero} {(𝒪 A ((𝒻0 f) x)) → (𝒪 A (src Δ (ref Δ ((𝒻0 f)x))))}{(𝒪 A ((𝒻0 f) x)) → (𝒪 A ((𝒻0 f) (src Γ (ref Γ x))))} {bsrc (ref Γ x)} {subst 𝒪 (sym ul Γ x)}
  (subst-cd {lzero}{𝒪 A ((𝒻0 f) x)} {𝒪 A (src Δ (ref Δ ((𝒻0 f)x)))} {𝒪 A ((𝒻0 f) (src Γ (ref Γ x)))} (subst3r {Γ = Γ}{Δ = Δ}{A = A}{x = x}{f = f})) (ptur A ((𝒻0 f) x))!} ]

--famifyHom : {Γ Δ : RG} → (f : HomRG Γ Δ) → FamRG⇒ Γ (ID Γ) (substTy (ID Δ) f)
--famifyHom f = {!!}

--famify⊤ : {Γ Δ : RG} → (f : HomRG Γ Δ) → FamRG⇒ Γ (⊤_ {Γ}) (substTy ⊤_{Δ} f)
--famify⊤ = ?

{-one could also take pointwise equality of reflexive graph families-}
--exch0⊤_ : {Γ Δ : RG} → {x : o Γ} → (f : HomRG Γ Δ ) → (𝒪 (⊤_{Γ = Γ}) x) ≡ (𝒪 (⊤_{Δ = Δ}) ((𝒻0 f) x))
--exch0⊤_ f = refl

substTm : {Γ Δ : RG} → {A : Ty Δ} → Tm Δ A → (f : HomRG Γ Δ) → Tm Γ (substTy A f )
substTm {Γ = Γ} {Δ = Δ} {A = A} M f = FamRG⇒[ (λ x → ((m𝒪 M ((𝒻0 f) x)))) , (λ y → ((m𝓡 M ((𝒻1 f) y)))) ,
                              (λ x → (subst (λ X → (X ≡ (bref (substTy {Γ = Γ} {Δ = Δ} A f) x) ∘ (m𝒪 M ((𝒻0 f)x)))) (cong-app (cong (m𝓡 M) ((𝒻ref f) x))(bref ⊤_ {Δ = Δ} ((𝒻0 f) x))  ))) ,
                              {!!} , {!!} ]

{-
substTm : {Γ Δ : RG} → {A : Ty Δ} → Tm Δ A → (f : HomRG Γ Δ) → Tm Γ (substTy A f )
substTm M f = ∘FamRG⇒ (famifyHom f) M

-}
{-
substTm : {Γ Δ : RG} → {A : Ty Δ} → Tm Δ A → (f : HomRG Γ Δ) → Tm Γ (substTy A f ) 
substTm M f = FamRG⇒[_ , _ , _ , _ , _]
-}


-- comprehension

_•_ : (Γ : RG) → (A : Ty Γ) → RG
Γ • A = RG[ (Σ (o Γ) (𝒪 A)) , (Σ (r Γ) (𝓡 A)) ,
            (λ x → (ref Γ (proj₁ x) , bref A (proj₁ x) (proj₂ x))) ,
            ( λ y → (src Γ (proj₁ y) , bsrc A (proj₁ y) (proj₂ y))) ,
            (λ y → (tgt Γ (proj₁ y) , btgt A (proj₁ y) (proj₂ y))) ,
            (λ w → (Σ-≡ (ul Γ (proj₁ w )) ({!!}))) ,
            {!!} ]

-- Pi-type for reflexive graphs
{-
PI : {Γ : RG} → (A : Ty Γ) → (B : Ty Γ • A) → Ty Γ
PI A B = FamRG[ (λ x → Σ[ (f₀ , f₁) ∈ (( a₀ : 𝒪 A x) → 𝒪 B (x , a)) × ((a₁ : 𝓡 A (ref Γ x)) → 𝓡 B (ref Γ x , a₁))]
                                   (
                                   ((a₁ : 𝓡 A (ref Γ x)) → bsrc B(ref Γ x , a₁) ( f₁ a₁) ≡ f₀ bsrc A (ref Γ x) a₁)
                                   ((a₁ : 𝓡 A (ref Γ x)) → btgt B(ref Γ x , a₁) ( f₁ a₁) ≡ f₀ btgt A (ref Γ x) a₁)
                                   ((a₀ : 𝒪 A x) → bref B (x , a₀) (f₀ a₀) ≡ f₁ (bref A x) a₀)
                )) ,
                (λ y → Σ[ (Fsrc , Ftgt , r) ∈ (𝒪 src Γ y) × (𝒪 tgt Γ y) × ((a₁ : 𝓡 A y) → 𝓡 B (y , a₁))]
                          (
                          (a₁ : 𝓡 A y) → (bsrc B (y , a₁)(r a₁) ≡ (proj₁ Fsrc)(bsrc A y a₁))
                          (a₁ : 𝓡 A y) → (btgt B (y , a₁)(r a₁) ≡ (proj₂ Fsrc)(btgt A y a₁))
                          )
                 ) ,
                ( λ x → (λ f → ( f , f , proj₁ f)) ,
                (λ y → (λ w → (proj₁ w))) ,
                (λ y → (λ w → (proj₂ w))) ,
                ? ,
                ?
                ]
-}

-- IR

{-for IR we need the following
RGRG = the collection of reflexive graphs as a (large) reflexive graph.
-}


-- cuts
{-
transport-subst-cd : {A B B' : Set} → ( q : B ≡ B') → {x y : A → B} → (p : x ≡ y) → (subst-cd q x ≡ subst-cd q y)
transport-subst-cd q p = ap (subst-cd q) p
-}

{-
the problem with this notation is that mixfix operators do not take implicit arguments
_[_]Ty : {Γ Δ : RG} → Ty Δ → (HomRG Γ Δ ) → Ty Γ
A [ f ]Ty = FamRG[ (𝒪 A) ∘ (𝒻0 f) ,
(𝓡 A) ∘ (𝒻1 f) , (λ x → ((subst (𝓡 A) (sym ((𝒻ref f) x))) ∘ ((bref A) ((𝒻0 f) x)))) ,
(λ y → (subst (𝒪 A) ((𝒻src f)y)) ∘ (bsrc A)((𝒻1 f) y)) ,
(λ y → (subst (𝒪 A) ((𝒻tgt f) y)) ∘ (btgt A)((𝒻1 f) y)) ,
(λ x →  ap (subst-cd unsubst3 {Γ = Γ}{Δ = Δ}{A = A}{x = x}{f = f}) (ptul A ((𝒻0 f) x))) ,
(λ x →  ap (subst-cd unsubst3r {Γ = Γ}{Δ = Δ}{A = A}{x = x}{f = f}) (ptur A ((𝒻0 f) x))) ]
-}

{-
we should have pointwise bref A [ f ] x ≡ bref A ((𝒻0 f) x) , but
for typing reasons we cannot take this as definition of the field
-}


{-
A = 𝒪 A (𝒻0 f x)
B = 𝒪 A src Δ (ref Δ ((𝒻0 f) x))
B' = 𝒪 A [ f ]Ty (src Γ (ref Γ x))
q = sym unsubst3
x =  ((brsc A (ref A ((𝒻0 f) x)) ∘ (bref A ((𝒻0 f) x))))
y = subst 𝒪 A (sym (ul Δ ((𝒻0 f) x ))))
p = ptul A ((𝒻0 f) x)
then q will be
transport-subst-cd A B B' q x y p = q = ptul (A [ f ]Ty x)
-}
